"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.internalRuleToAPIResponse = void 0;
var _transform_actions = require("../../../../../../../common/detection_engine/transform_actions");
var _rule_monitoring = require("../../../../rule_monitoring");
var _rule_actions = require("../../../normalization/rule_actions");
var _type_specific_camel_to_snake = require("./type_specific_camel_to_snake");
var _common_params_camel_to_snake = require("./common_params_camel_to_snake");
var _normalize_rule_params = require("./normalize_rule_params");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const internalRuleToAPIResponse = rule => {
  var _rule$systemActions, _rule$updatedBy, _rule$createdBy;
  const executionSummary = (0, _rule_monitoring.createRuleExecutionSummary)(rule);
  const isResolvedRule = obj => {
    const outcome = obj.outcome;
    return outcome != null && outcome !== 'exactMatch';
  };
  const alertActions = rule.actions.map(_transform_actions.transformAlertToRuleAction);
  const throttle = (0, _rule_actions.transformFromAlertThrottle)(rule);
  const actions = (0, _rule_actions.transformToActionFrequency)(alertActions, throttle);
  const systemActions = (_rule$systemActions = rule.systemActions) === null || _rule$systemActions === void 0 ? void 0 : _rule$systemActions.map(action => {
    const transformedAction = (0, _transform_actions.transformAlertToRuleSystemAction)(action);
    return transformedAction;
  });
  const normalizedRuleParams = (0, _normalize_rule_params.normalizeRuleParams)(rule.params);
  return {
    // saved object properties
    outcome: isResolvedRule(rule) ? rule.outcome : undefined,
    alias_target_id: isResolvedRule(rule) ? rule.alias_target_id : undefined,
    alias_purpose: isResolvedRule(rule) ? rule.alias_purpose : undefined,
    // Alerting framework params
    id: rule.id,
    updated_at: rule.updatedAt.toISOString(),
    updated_by: (_rule$updatedBy = rule.updatedBy) !== null && _rule$updatedBy !== void 0 ? _rule$updatedBy : 'elastic',
    created_at: rule.createdAt.toISOString(),
    created_by: (_rule$createdBy = rule.createdBy) !== null && _rule$createdBy !== void 0 ? _rule$createdBy : 'elastic',
    name: rule.name,
    tags: rule.tags,
    interval: rule.schedule.interval,
    enabled: rule.enabled,
    revision: rule.revision,
    // Security solution shared rule params
    ...(0, _common_params_camel_to_snake.normalizedCommonParamsCamelToSnake)(normalizedRuleParams),
    // Type specific security solution rule params
    ...(0, _type_specific_camel_to_snake.typeSpecificCamelToSnake)(rule.params),
    // Actions
    throttle: undefined,
    actions: [...actions, ...(systemActions !== null && systemActions !== void 0 ? systemActions : [])],
    // Execution summary
    execution_summary: executionSummary !== null && executionSummary !== void 0 ? executionSummary : undefined
  };
};
exports.internalRuleToAPIResponse = internalRuleToAPIResponse;