"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerUpdateInsightsRoute = void 0;
var _workflow_insights = require("../../../../common/api/endpoint/workflow_insights/workflow_insights");
var _services = require("../../services");
var _error_handler = require("../error_handler");
var _constants = require("../../../../common/endpoint/constants");
var _with_endpoint_authz = require("../with_endpoint_authz");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerUpdateInsightsRoute = (router, endpointContext) => {
  router.versioned.put({
    access: 'internal',
    path: _constants.WORKFLOW_INSIGHTS_UPDATE_ROUTE,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution']
      }
    },
    options: {
      authRequired: true
    }
  }).addVersion({
    version: '1',
    validate: {
      request: _workflow_insights.UpdateWorkflowInsightRequestSchema
    }
  }, (0, _with_endpoint_authz.withEndpointAuthz)({
    all: ['canWriteWorkflowInsights']
  }, endpointContext.logFactory.get('workflowInsights'), updateInsightsRouteHandler(endpointContext)));
};
exports.registerUpdateInsightsRoute = registerUpdateInsightsRoute;
const updateInsightsRouteHandler = endpointContext => {
  const logger = endpointContext.logFactory.get('workflowInsights');
  return async (_, request, response) => {
    const {
      insightId
    } = request.params;
    logger.debug(`Updating insight ${insightId}`);
    try {
      const body = await _services.securityWorkflowInsightsService.update(insightId, request.body);
      return response.ok({
        body
      });
    } catch (e) {
      return (0, _error_handler.errorHandler)(logger, response, e);
    }
  };
};