"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UploadListItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _securitysolutionListHooks = require("@kbn/securitysolution-list-hooks");
var _kibana = require("../../common/lib/kibana");
var _use_app_toasts = require("../../common/hooks/use_app_toasts");
var _translations = require("../translations");
var _telemetry = require("../../common/lib/telemetry");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validFileTypes = ['text/csv', 'text/plain'];
const toastOptions = {
  toastLifeTimeMs: 5000
};
const uploadStyle = (0, _css.css)`
  min-width: 300px;
`;
const UploadListItem = ({
  listId,
  type
}) => {
  const [file, setFile] = (0, _react.useState)(null);
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const ctrl = (0, _react.useRef)(new AbortController());
  const {
    start: importList,
    ...importState
  } = (0, _securitysolutionListHooks.useImportList)();
  const invalidateListItemQuery = (0, _securitysolutionListHooks.useInvalidateListItemQuery)();
  const {
    addSuccess,
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const handleFileChange = (0, _react.useCallback)(files => {
    var _files$item;
    setFile((_files$item = files === null || files === void 0 ? void 0 : files.item(0)) !== null && _files$item !== void 0 ? _files$item : null);
  }, []);
  const handleImport = (0, _react.useCallback)(() => {
    if (!importState.loading && file) {
      ctrl.current = new AbortController();
      (0, _telemetry.track)(_telemetry.METRIC_TYPE.COUNT, _telemetry.TELEMETRY_EVENT.ADDITIONAL_UPLOAD_VALUE_LIST_ITEM);
      importList({
        file,
        listId,
        http,
        signal: ctrl.current.signal,
        type,
        refresh: 'true'
      });
    }
  }, [importState.loading, file, importList, http, type, listId]);
  const fileIsValid = !file || validFileTypes.some(fileType => file.type === fileType);
  (0, _react.useEffect)(() => {
    if (!importState.loading && importState.result) {
      addSuccess(_translations.SUCCESSFULY_UPLOAD_LIST_ITEMS, toastOptions);
    } else if (!importState.loading && importState.error) {
      addError(_translations.FAILED_TO_UPLOAD_LIST_ITEM, {
        title: _translations.FAILED_TO_UPLOAD_LIST_ITEM_TITLE,
        ...toastOptions
      });
    }
    invalidateListItemQuery();
  }, [importState.error, importState.loading, importState.result, addSuccess, addError, invalidateListItemQuery]);
  const isDisabled = file == null || !fileIsValid || importState.loading;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    content: _translations.UPLOAD_TOOLTIP
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    className: uploadStyle,
    accept: validFileTypes.join(),
    id: "value-list-item-upload",
    initialPromptText: _translations.UPLOAD_FILE_PICKER_INITAL_PROMT_TEXT,
    onChange: handleFileChange,
    display: "default",
    isLoading: importState.loading,
    isInvalid: !fileIsValid,
    "data-test-subj": "value-list-items-file-picker"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: handleImport,
    disabled: isDisabled,
    "data-test-subj": "value-list-items-upload"
  }, _translations.UPLOAD_LIST_ITEM));
};
exports.UploadListItem = UploadListItem;