"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SUCCESSFULLY_CREATED_RULES = exports.PAGE_TITLE = exports.EDIT_RULE = exports.COMPLETE_WITH_ENABLING = exports.COMPLETE_WITHOUT_ENABLING = exports.CANCEL_BUTTON_LABEL = exports.BACK_TO_RULES = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PAGE_TITLE = exports.PAGE_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.pageTitle', {
  defaultMessage: 'Create new rule'
});
const BACK_TO_RULES = exports.BACK_TO_RULES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.backToRulesButton', {
  defaultMessage: 'Rules'
});
const CANCEL_BUTTON_LABEL = exports.CANCEL_BUTTON_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.cancelButtonLabel', {
  defaultMessage: 'Cancel'
});
const EDIT_RULE = exports.EDIT_RULE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.editRuleButton', {
  defaultMessage: 'Edit'
});
const SUCCESSFULLY_CREATED_RULES = ruleName => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.create.successfullyCreatedRuleTitle', {
  values: {
    ruleName
  },
  defaultMessage: '{ruleName} was created'
});
exports.SUCCESSFULLY_CREATED_RULES = SUCCESSFULLY_CREATED_RULES;
const COMPLETE_WITHOUT_ENABLING = exports.COMPLETE_WITHOUT_ENABLING = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepScheduleRule.completeWithoutEnablingTitle', {
  defaultMessage: 'Create rule without enabling it'
});
const COMPLETE_WITH_ENABLING = exports.COMPLETE_WITH_ENABLING = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepScheduleRule.completeWithEnablingTitle', {
  defaultMessage: 'Create & enable rule'
});