"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useManagedDataViews = void 0;
var _public = require("@kbn/data-views-plugin/public");
var _reactRedux = require("react-redux");
var _react = require("react");
var _constants = require("../../../common/constants");
var _kibana = require("../../common/lib/kibana");
var _selectors = require("../redux/selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns the default security solution data view and alert data view
 */
const useManagedDataViews = () => {
  const {
    dataViews: dataViewSpecs,
    adhocDataViews,
    defaultDataViewId,
    alertDataViewId
  } = (0, _reactRedux.useSelector)(_selectors.sharedStateSelector);
  const {
    services: {
      fieldFormats
    }
  } = (0, _kibana.useKibana)();
  return (0, _react.useMemo)(() => [...dataViewSpecs, ...adhocDataViews].filter(dv => {
    var _dv$id;
    return dv.id === defaultDataViewId || dv.id === alertDataViewId || ((_dv$id = dv.id) === null || _dv$id === void 0 ? void 0 : _dv$id.startsWith(_constants.EXPLORE_DATA_VIEW_PREFIX));
  }).map(spec => new _public.DataView({
    spec,
    fieldFormats
  })), [dataViewSpecs, adhocDataViews, defaultDataViewId, alertDataViewId, fieldFormats]);
};
exports.useManagedDataViews = useManagedDataViews;