"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppRootProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _common = require("@kbn/kibana-react-plugin/common");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _public = require("@kbn/kibana-react-plugin/public");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _reactQuery = require("@kbn/react-query");
var _upselling_provider = require("../../components/upselling_provider");
var _console = require("../../../management/components/console");
var _mock_assistant_provider = require("../mock_assistant_provider");
var _route_capture = require("../../components/endpoint/route_capture");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Provides the context for rendering the endpoint app
 */
const AppRootProvider = exports.AppRootProvider = /*#__PURE__*/(0, _react.memo)(({
  store,
  history,
  coreStart,
  queryClient,
  startServices,
  children
}) => {
  const isDarkMode = (0, _reactKibanaContextTheme.useKibanaIsDarkMode)();
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, coreStart, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: store
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: startServices
  }, /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
    darkMode: isDarkMode
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient
  }, /*#__PURE__*/_react.default.createElement(_upselling_provider.UpsellingProvider, {
    upsellingService: startServices.upselling
  }, /*#__PURE__*/_react.default.createElement(_mock_assistant_provider.MockAssistantProvider, null, /*#__PURE__*/_react.default.createElement(_securitySolutionNavigation.NavigationProvider, {
    core: coreStart
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_console.ConsoleManager, null, /*#__PURE__*/_react.default.createElement(_route_capture.RouteCapture, null, children)))))))))));
});
AppRootProvider.displayName = 'AppRootProvider';