"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTermsAggregationFields = useTermsAggregationFields;
var _react = require("react");
var _utils = require("../../detection_engine/rule_creation_ui/components/step_define_rule/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useTermsAggregationFields(fields) {
  const termsAggregationFields = (0, _react.useMemo)(
  /**
   * Typecasting to FieldSpec because fields is
   * typed as DataViewFieldBase[] which does not have
   * the 'aggregatable' property, however the type is incorrect
   *
   * fields does contain elements with the aggregatable property.
   * We will need to determine where these types are defined and
   * figure out where the discrepancy is.
   */
  () => {
    var _ref;
    return (0, _utils.getTermsAggregationFields)((_ref = fields) !== null && _ref !== void 0 ? _ref : []);
  }, [fields]);
  return termsAggregationFields;
}