"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExternalReferenceAttachmentEndpointRegular = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _lazy_external_reference_children_content = require("./lazy_external_reference_children_content");
var _constants = require("../../../common/constants");
var _lazy_external_reference_content = require("./lazy_external_reference_content");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getExternalReferenceAttachmentEndpointRegular = () => ({
  id: _constants.CASE_ATTACHMENT_ENDPOINT_TYPE_ID,
  displayName: 'Endpoint',
  // @ts-expect-error: TS2322 figure out types for children lazyExotic
  getAttachmentViewObject: props => {
    var _props$externalRefere;
    const iconType = ((_props$externalRefere = props.externalReferenceMetadata) === null || _props$externalRefere === void 0 ? void 0 : _props$externalRefere.command) === 'isolate' ? 'lock' : 'lockOpen';
    return {
      type: 'regular',
      event: (0, _lazy_external_reference_content.getLazyExternalEventContent)(props),
      timelineAvatar: /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
        name: "endpoint",
        color: "subdued",
        iconType: iconType,
        "aria-label": iconType
      }),
      children: _lazy_external_reference_children_content.getLazyExternalChildrenContent
    };
  }
});
exports.getExternalReferenceAttachmentEndpointRegular = getExternalReferenceAttachmentEndpointRegular;