"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.splResourceIdentifiers = void 0;
var _splunk_identifier = require("./splunk_identifier");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const splResourceIdentifiers = exports.splResourceIdentifiers = {
  fromOriginalRule: originalRule => (0, _splunk_identifier.splResourceIdentifier)(originalRule.query),
  fromResource: resource => {
    if (resource.type === 'macro' && resource.content) {
      return (0, _splunk_identifier.splResourceIdentifier)(resource.content);
    }
    return [];
  }
};