"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCasesSubFeaturesMapV3 = exports.getCasesBaseKibanaSubFeatureIdsV3 = void 0;
var _i18n = require("@kbn/i18n");
var _product_features_keys = require("../../product_features_keys");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Sub-features that will always be available for Security Cases
 * regardless of the product type.
 */
const getCasesBaseKibanaSubFeatureIdsV3 = () => [_product_features_keys.CasesSubFeatureId.deleteCases, _product_features_keys.CasesSubFeatureId.casesSettings, _product_features_keys.CasesSubFeatureId.createComment, _product_features_keys.CasesSubFeatureId.reopenCase, _product_features_keys.CasesSubFeatureId.assignUsers];

/**
 * Defines all the Security Solution Cases subFeatures available.
 * The order of the subFeatures is the order they will be displayed
 */
exports.getCasesBaseKibanaSubFeatureIdsV3 = getCasesBaseKibanaSubFeatureIdsV3;
const getCasesSubFeaturesMapV3 = ({
  uiCapabilities,
  apiTags,
  savedObjects
}) => {
  const deleteCasesSubFeature = {
    name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.deleteSubFeatureName', {
      defaultMessage: 'Delete'
    }),
    privilegeGroups: [{
      groupType: 'independent',
      privileges: [{
        api: apiTags.delete,
        id: 'cases_delete',
        name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.deleteSubFeatureDetails', {
          defaultMessage: 'Delete cases and comments'
        }),
        includeIn: 'all',
        savedObject: {
          all: [...savedObjects.files],
          read: [...savedObjects.files]
        },
        cases: {
          delete: [_constants.APP_ID]
        },
        ui: uiCapabilities.delete
      }]
    }]
  };
  const casesSettingsCasesSubFeature = {
    name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.casesSettingsSubFeatureName', {
      defaultMessage: 'Case settings'
    }),
    privilegeGroups: [{
      groupType: 'independent',
      privileges: [{
        id: 'cases_settings',
        name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.casesSettingsSubFeatureDetails', {
          defaultMessage: 'Edit case settings'
        }),
        includeIn: 'all',
        savedObject: {
          all: [...savedObjects.files],
          read: [...savedObjects.files]
        },
        cases: {
          settings: [_constants.APP_ID]
        },
        ui: uiCapabilities.settings
      }]
    }]
  };
  const casesAddCommentsCasesSubFeature = {
    name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.addCommentsSubFeatureName', {
      defaultMessage: 'Create comments & attachments'
    }),
    privilegeGroups: [{
      groupType: 'independent',
      privileges: [{
        api: apiTags.createComment,
        id: 'create_comment',
        name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.addCommentsSubFeatureDetails', {
          defaultMessage: 'Add comments to cases'
        }),
        includeIn: 'all',
        savedObject: {
          all: [...savedObjects.files],
          read: [...savedObjects.files]
        },
        cases: {
          createComment: [_constants.APP_ID]
        },
        ui: uiCapabilities.createComment
      }]
    }]
  };
  const casesreopenCaseSubFeature = {
    name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.reopenCaseSubFeatureName', {
      defaultMessage: 'Re-open'
    }),
    privilegeGroups: [{
      groupType: 'independent',
      privileges: [{
        id: 'case_reopen',
        name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.reopenCaseSubFeatureDetails', {
          defaultMessage: 'Re-open closed cases'
        }),
        includeIn: 'all',
        savedObject: {
          all: [],
          read: []
        },
        cases: {
          reopenCase: [_constants.APP_ID]
        },
        ui: uiCapabilities.reopenCase
      }]
    }]
  };
  const casesAssignUsersCasesSubFeature = {
    name: _i18n.i18n.translate('securitySolutionPackages.features.assignUsersSubFeatureName', {
      defaultMessage: 'Assign users'
    }),
    privilegeGroups: [{
      groupType: 'independent',
      privileges: [{
        id: 'cases_assign',
        name: _i18n.i18n.translate('securitySolutionPackages.features.assignUsersSubFeatureName', {
          defaultMessage: 'Assign users to cases'
        }),
        includeIn: 'all',
        savedObject: {
          all: [],
          read: []
        },
        cases: {
          assign: [_constants.APP_ID]
        },
        ui: uiCapabilities.assignCase
      }]
    }]
  };
  return new Map([[_product_features_keys.CasesSubFeatureId.deleteCases, deleteCasesSubFeature], [_product_features_keys.CasesSubFeatureId.casesSettings, casesSettingsCasesSubFeature], [_product_features_keys.CasesSubFeatureId.createComment, casesAddCommentsCasesSubFeature], [_product_features_keys.CasesSubFeatureId.reopenCase, casesreopenCaseSubFeature], [_product_features_keys.CasesSubFeatureId.assignUsers, casesAssignUsersCasesSubFeature]]);
};
exports.getCasesSubFeaturesMapV3 = getCasesSubFeaturesMapV3;