"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useQueryIndices = void 0;
var _reactQuery = require("@kbn/react-query");
var _use_kibana = require("./use_kibana");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useQueryIndices = (query = '') => {
  const {
    services
  } = (0, _use_kibana.useKibana)();
  const {
    data,
    isLoading
  } = (0, _reactQuery.useQuery)({
    queryKey: ['indices', query],
    queryFn: async () => {
      const response = await services.http.get(_types.APIRoutes.GET_INDICES, {
        query: {
          search_query: query,
          size: 10
        }
      });
      return response.indices;
    },
    initialData: []
  });
  return {
    indices: data,
    isLoading
  };
};
exports.useQueryIndices = useQueryIndices;