"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sortSchema = exports.sortOrderSchema = exports.minDocCount = exports.metricsAggsSchemas = exports.bucketAggsSchemas = exports.alertsGroupFilterSchema = exports.alertsAggregationsSchema = void 0;
var t = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// note: these schemas are not exhaustive. See the `Sort` type of `@elastic/elasticsearch` if you need to enhance it.
const fieldSchema = t.string;
const sortOrderSchema = exports.sortOrderSchema = t.union([t.literal('asc'), t.literal('desc'), t.literal('_doc')]);
const sortModeSchema = t.union([t.literal('min'), t.literal('max'), t.literal('sum'), t.literal('avg'), t.literal('median')]);
const fieldSortSchema = t.exact(t.partial({
  missing: t.union([t.string, t.number, t.boolean]),
  mode: sortModeSchema,
  order: sortOrderSchema
  // nested and unmapped_type not implemented yet
}));
const sortContainerSchema = t.record(t.string, t.union([sortOrderSchema, fieldSortSchema]));
const sortCombinationsSchema = t.union([fieldSchema, sortContainerSchema]);
const sortSchema = exports.sortSchema = t.union([sortCombinationsSchema, t.array(sortCombinationsSchema)]);
const minDocCount = exports.minDocCount = t.number;
/**
 * Schemas for the Bucket aggregations.
 *
 * Currently supported:
 * - filter
 * - histogram
 * - nested
 * - terms
 *
 * Not implemented:
 * - adjacency_matrix
 * - auto_date_histogram
 * - children
 * - composite
 * - date_histogram
 * - date_range
 * - diversified_sampler
 * - filters
 * - geo_distance
 * - geohash_grid
 * - geotile_grid
 * - global
 * - ip_range
 * - missing
 * - multi_terms
 * - parent
 * - range
 * - rare_terms
 * - reverse_nested
 * - sampler
 * - significant_terms
 * - significant_text
 * - variable_width_histogram
 */
const bucketAggsTempsSchemas = t.exact(t.partial({
  filter: t.exact(t.partial({
    term: t.record(t.string, t.union([t.string, t.boolean, t.number]))
  })),
  date_histogram: t.exact(t.partial({
    field: t.string,
    fixed_interval: t.string,
    min_doc_count: t.number,
    extended_bounds: t.type({
      min: t.string,
      max: t.string
    })
  })),
  histogram: t.exact(t.partial({
    field: t.string,
    interval: t.number,
    min_doc_count: t.number,
    extended_bounds: t.exact(t.type({
      min: t.number,
      max: t.number
    })),
    hard_bounds: t.exact(t.type({
      min: t.number,
      max: t.number
    })),
    missing: t.number,
    keyed: t.boolean,
    order: t.exact(t.type({
      _count: t.string,
      _key: t.string
    }))
  })),
  nested: t.type({
    path: t.string
  }),
  multi_terms: t.exact(t.partial({
    terms: t.array(t.type({
      field: t.string
    })),
    collect_mode: t.string,
    min_doc_count: t.number,
    shard_min_doc_count: t.number,
    size: t.number,
    shard_size: t.number,
    show_term_doc_count_error: t.boolean,
    order: t.union([sortOrderSchema, t.record(t.string, sortOrderSchema), t.array(t.record(t.string, sortOrderSchema))])
  })),
  terms: t.exact(t.partial({
    field: t.string,
    collect_mode: t.string,
    exclude: t.union([t.string, t.array(t.string)]),
    include: t.union([t.string, t.array(t.string)]),
    execution_hint: t.string,
    missing: t.union([t.number, t.string]),
    min_doc_count: t.number,
    size: t.number,
    show_term_doc_count_error: t.boolean,
    order: t.union([sortOrderSchema, t.record(t.string, sortOrderSchema), t.array(t.record(t.string, sortOrderSchema))])
  })),
  bucket_sort: t.exact(t.partial({
    sort: sortSchema,
    from: t.number,
    size: t.number,
    gap_policy: t.union([t.literal('skip'), t.literal('insert_zeros'), t.literal('keep_values')])
  })),
  value_count: t.exact(t.partial({
    field: t.string
  }))
}));

/**
 * Schemas for the metrics Aggregations
 *
 * Currently supported:
 * - avg
 * - cardinality
 * - min
 * - max
 * - sum
 * - top_hits
 * - weighted_avg
 *
 * Not implemented:
 * - boxplot
 * - extended_stats
 * - geo_bounds
 * - geo_centroid
 * - geo_line
 * - matrix_stats
 * - median_absolute_deviation
 * - percentile_ranks
 * - percentiles
 * - rate
 * - scripted_metric
 * - stats
 * - string_stats
 * - t_test
 * - value_count
 */
const metricsAggsSchemas = exports.metricsAggsSchemas = t.exact(t.partial({
  avg: t.exact(t.partial({
    field: t.string,
    missing: t.union([t.string, t.number, t.boolean])
  })),
  cardinality: t.exact(t.partial({
    field: t.string,
    precision_threshold: t.number,
    rehash: t.boolean,
    missing: t.union([t.string, t.number, t.boolean])
  })),
  min: t.exact(t.partial({
    field: t.string,
    missing: t.union([t.string, t.number, t.boolean]),
    format: t.string
  })),
  max: t.exact(t.partial({
    field: t.string,
    missing: t.union([t.string, t.number, t.boolean]),
    format: t.string
  })),
  sum: t.exact(t.partial({
    field: t.string,
    missing: t.union([t.string, t.number, t.boolean])
  })),
  top_hits: t.exact(t.partial({
    explain: t.boolean,
    docvalue_fields: t.union([t.string, t.array(t.string)]),
    stored_fields: t.union([t.string, t.array(t.string)]),
    from: t.number,
    size: t.number,
    sort: sortSchema,
    seq_no_primary_term: t.boolean,
    version: t.boolean,
    track_scores: t.boolean,
    highlight: t.any,
    _source: t.union([t.boolean, t.string, t.array(t.string)])
  })),
  weighted_avg: t.exact(t.partial({
    format: t.string,
    value_type: t.string,
    value: t.partial({
      field: t.string,
      missing: t.number
    }),
    weight: t.partial({
      field: t.string,
      missing: t.number
    })
  }))
}));
const bucketAggsSchemas = exports.bucketAggsSchemas = t.intersection([bucketAggsTempsSchemas, t.exact(t.partial({
  aggs: t.record(t.string, t.intersection([bucketAggsTempsSchemas, metricsAggsSchemas])),
  aggregations: t.record(t.string, t.intersection([bucketAggsTempsSchemas, metricsAggsSchemas]))
}))]);
const alertsAggregationsSchema = exports.alertsAggregationsSchema = t.record(t.string, t.intersection([metricsAggsSchemas, bucketAggsSchemas]));
const allowedFilterKeysSchema = t.union([t.literal('bool'), t.literal('boosting'), t.literal('common'), t.literal('combined_fields'), t.literal('constant_score'), t.literal('dis_max'), t.literal('distance_feature'), t.literal('exists'), t.literal('function_score'), t.literal('fuzzy'), t.literal('geo_bounding_box'), t.literal('geo_distance'), t.literal('geo_polygon'), t.literal('geo_shape'), t.literal('has_child'), t.literal('has_parent'), t.literal('ids'), t.literal('intervals'), t.literal('knn'), t.literal('match'), t.literal('match_all'), t.literal('match_bool_prefix'), t.literal('match_none'), t.literal('match_phrase'), t.literal('match_phrase_prefix'), t.literal('more_like_this'), t.literal('multi_match'), t.literal('nested'), t.literal('parent_id'), t.literal('percolate'), t.literal('pinned'), t.literal('prefix'), t.literal('query_string'), t.literal('range'), t.literal('rank_feature'), t.literal('regexp'), t.literal('rule'), t.literal('semantic'), t.literal('shape'), t.literal('simple_query_string'), t.literal('span_containing'), t.literal('span_field_masking'), t.literal('span_first'), t.literal('span_multi'), t.literal('span_near'), t.literal('span_not'), t.literal('span_or'), t.literal('span_term'), t.literal('span_within'), t.literal('term'), t.literal('terms'), t.literal('terms_set'), t.literal('text_expansion'), t.literal('weighted_tokens'), t.literal('wildcard'), t.literal('wrapper'), t.literal('type')]);

// Used to check that the validation schema is aligned with the type from ES

const alertsGroupFilterSchema = exports.alertsGroupFilterSchema = t.record(allowedFilterKeysSchema, t.any);