"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = void 0;
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _ebtTools = require("@kbn/ebt-tools");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _eui = require("@elastic/eui");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _public3 = require("@kbn/observability-shared-plugin/public");
var _check_setup = require("./components/check_setup");
var _profiling_dependencies_context = require("./components/contexts/profiling_dependencies/profiling_dependencies_context");
var _route_breadcrumbs_context = require("./components/contexts/route_breadcrumbs_context");
var _time_range_context = require("./components/contexts/time_range_context");
var _redirect_with_default_date_range = require("./components/redirect_with_default_date_range");
var _routing = require("./routing");
var _profiling_header_action_menu = require("./components/profiling_header_action_menu");
var _router_error_boundary = require("./routing/router_error_boundary");
var _license_context = require("./components/contexts/license/license_context");
var _profiling_setup_status_context = require("./components/contexts/profiling_setup_status/profiling_setup_status_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const storage = new _public2.Storage(localStorage);
function MountProfilingActionMenu({
  theme$,
  setHeaderActionMenu
}) {
  return /*#__PURE__*/_react.default.createElement(_public3.HeaderMenuPortal, {
    setHeaderActionMenu: setHeaderActionMenu,
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_profiling_header_action_menu.ProfilingHeaderActionMenu, null))));
}
function App({
  coreStart,
  coreSetup,
  pluginsStart,
  pluginsSetup,
  profilingFetchServices,
  theme$,
  history,
  setHeaderActionMenu
}) {
  const i18nCore = coreStart.i18n;
  const profilingDependencies = (0, _react.useMemo)(() => {
    return {
      start: {
        core: coreStart,
        ...pluginsStart
      },
      setup: {
        core: coreSetup,
        ...pluginsSetup
      },
      services: profilingFetchServices
    };
  }, [coreStart, coreSetup, pluginsStart, pluginsSetup, profilingFetchServices]);
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, coreStart, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...coreStart,
      ...pluginsStart,
      storage
    }
  }, /*#__PURE__*/_react.default.createElement(i18nCore.Context, null, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: coreStart,
    currentAppId: "profiling"
  }, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.RouterProvider, {
    router: _routing.profilingRouter,
    history: history
  }, /*#__PURE__*/_react.default.createElement(_ebtTools.PerformanceContextProvider, null, /*#__PURE__*/_react.default.createElement(_router_error_boundary.RouterErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_time_range_context.TimeRangeContextProvider, null, /*#__PURE__*/_react.default.createElement(_profiling_dependencies_context.ProfilingDependenciesContextProvider, {
    value: profilingDependencies
  }, /*#__PURE__*/_react.default.createElement(_profiling_setup_status_context.ProfilingSetupStatusContextProvider, null, /*#__PURE__*/_react.default.createElement(_license_context.LicenseProvider, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_check_setup.CheckSetup, null, /*#__PURE__*/_react.default.createElement(_redirect_with_default_date_range.RedirectWithDefaultDateRange, null, /*#__PURE__*/_react.default.createElement(_route_breadcrumbs_context.RouteBreadcrumbsContextProvider, null, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.RouteRenderer, null)))), /*#__PURE__*/_react.default.createElement(MountProfilingActionMenu, {
    setHeaderActionMenu: setHeaderActionMenu,
    theme$: theme$
  })))))))))))));
}
const renderApp = (props, element) => {
  _reactDom.default.render(/*#__PURE__*/_react.default.createElement(App, props), element);
  return () => _reactDom.default.unmountComponentAtNode(element);
};
exports.renderApp = renderApp;