"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sortAndTruncateAnalyzedFields = sortAndTruncateAnalyzedFields;
var _lodash = require("lodash");
var _inferenceCommon = require("@kbn/inference-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function sortAndTruncateAnalyzedFields(analysis) {
  const {
    fields,
    ...meta
  } = analysis;
  const [nonEmptyFields, emptyFields] = (0, _lodash.partition)(analysis.fields, field => !field.empty);
  const sortedFields = [...(0, _lodash.shuffle)(nonEmptyFields), ...(0, _lodash.shuffle)(emptyFields)];
  return {
    ...meta,
    fields: (0, _inferenceCommon.truncateList)(sortedFields.map(field => {
      let label = `${field.name}:${field.types.join(',')}`;
      if (field.empty) {
        return `${name} (empty)`;
      }
      label += ` - ${field.cardinality} distinct values`;
      if (field.name === '@timestamp' || field.name === 'event.ingested') {
        return `${label}`;
      }
      const shortValues = field.values.filter(value => {
        return String(value).length <= 1024;
      });
      if (shortValues.length) {
        return `${label} (${(0, _inferenceCommon.truncateList)(shortValues.map(value => '`' + value + '`'), field.types.includes('text') || field.types.includes('match_only_text') ? 2 : 10).join(', ')})`;
      }
      return label;
    }), 500).sort()
  };
}