"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilitySharedPlugin = void 0;
Object.defineProperty(exports, "updateGlobalNavigation", {
  enumerable: true,
  get: function () {
    return _update_global_navigation.updateGlobalNavigation;
  }
});
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _page_template = require("./components/page_template");
var _navigation_registry = require("./components/page_template/helpers/navigation_registry");
var _component_registry = require("./components/profiling/helpers/component_registry");
var _update_global_navigation = require("./services/update_global_navigation");
var _common = require("../common");
var _dependency_overview_locator = require("../common/locators/apm/dependency_overview_locator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ObservabilitySharedPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "navigationRegistry", (0, _navigation_registry.createNavigationRegistry)());
    (0, _defineProperty2.default)(this, "isSidebarEnabled$", void 0);
    this.isSidebarEnabled$ = new _rxjs.BehaviorSubject(true);
  }
  setup(coreSetup, pluginsSetup) {
    coreSetup.getStartServices().then(([coreStart]) => {
      coreStart.chrome.getChromeStyle$().subscribe(style => this.isSidebarEnabled$.next(style === 'classic'));
    });
    return {
      registerProfilingComponent: _component_registry.registerProfilingComponent,
      locators: this.createLocators(pluginsSetup.share.url),
      navigation: {
        registerSections: this.navigationRegistry.registerSections
      }
    };
  }
  start(core, plugins) {
    var _plugins$guidedOnboar;
    const {
      application
    } = core;
    const PageTemplate = (0, _page_template.createLazyObservabilityPageTemplate)({
      currentAppId$: application.currentAppId$,
      getUrlForApp: application.getUrlForApp,
      navigateToApp: application.navigateToApp,
      navigationSections$: this.navigationRegistry.sections$,
      guidedOnboardingApi: (_plugins$guidedOnboar = plugins.guidedOnboarding) === null || _plugins$guidedOnboar === void 0 ? void 0 : _plugins$guidedOnboar.guidedOnboardingApi,
      getPageTemplateServices: () => ({
        coreStart: core
      }),
      isSidebarEnabled$: this.isSidebarEnabled$
    });
    return {
      locators: this.createLocators(plugins.share.url),
      navigation: {
        PageTemplate,
        registerSections: this.navigationRegistry.registerSections
      },
      updateGlobalNavigation: _update_global_navigation.updateGlobalNavigation
    };
  }
  stop() {}
  createLocators(urlService) {
    return {
      infra: {
        assetDetailsLocator: urlService.locators.create(new _common.AssetDetailsLocatorDefinition()),
        assetDetailsFlyoutLocator: urlService.locators.create(new _common.AssetDetailsFlyoutLocatorDefinition()),
        hostsLocator: urlService.locators.create(new _common.HostsLocatorDefinition()),
        inventoryLocator: urlService.locators.create(new _common.InventoryLocatorDefinition()),
        metricsExplorerLocator: urlService.locators.create(new _common.MetricsExplorerLocatorDefinition())
      },
      profiling: {
        flamegraphLocator: urlService.locators.create(new _common.FlamegraphLocatorDefinition()),
        topNFunctionsLocator: urlService.locators.create(new _common.TopNFunctionsLocatorDefinition()),
        stacktracesLocator: urlService.locators.create(new _common.StacktracesLocatorDefinition())
      },
      apm: {
        serviceOverview: urlService.locators.create(new _common.ServiceOverviewLocatorDefinition()),
        dependencyOverview: urlService.locators.create(new _dependency_overview_locator.DependencyOverviewLocatorDefinition()),
        transactionDetailsByName: urlService.locators.create(new _common.TransactionDetailsByNameLocatorDefinition()),
        transactionDetailsByTraceId: urlService.locators.create(new _common.TransactionDetailsByTraceIdLocatorDefinition())
      }
    };
  }
}
exports.ObservabilitySharedPlugin = ObservabilitySharedPlugin;