"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderGroupPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _src = require("@kbn/grouping/src");
var _i18nReact = require("@kbn/i18n-react");
var _tags = require("../../tags");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const renderGroupPanel = (selectedGroup, bucket) => {
  var _bucket$ruleTags;
  switch (selectedGroup) {
    case 'kibana.alert.rule.name':
      return (0, _fp.isArray)(bucket.key) ? /*#__PURE__*/_react.default.createElement(RuleNameGroupContent, {
        ruleName: bucket.key[0],
        tags: (_bucket$ruleTags = bucket.ruleTags) === null || _bucket$ruleTags === void 0 ? void 0 : _bucket$ruleTags.buckets.map(tag => tag.key)
      }) : undefined;
    case 'kibana.alert.instance.id':
      return /*#__PURE__*/_react.default.createElement(InstanceIdGroupContent, {
        instanceId: (0, _src.firstNonNullValue)(bucket.key)
      });
  }
};
exports.renderGroupPanel = renderGroupPanel;
const RuleNameGroupContent = /*#__PURE__*/_react.default.memo(({
  ruleName,
  tags
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: 'table',
      tableLayout: 'fixed',
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "rule-name-group-renderer",
    gutterSize: "m",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      display: 'contents'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", {
    className: "eui-textTruncate"
  }, ruleName)))), !!tags && tags.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_tags.Tags, {
    tags: tags,
    color: "hollow",
    size: 5,
    oneLine: true
  })));
});
RuleNameGroupContent.displayName = 'RuleNameGroup';
const InstanceIdGroupContent = /*#__PURE__*/_react.default.memo(({
  instanceId
}) => {
  const isUngrouped = instanceId === '*';
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: 'table',
      tableLayout: 'fixed',
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "rule-name-group-renderer",
    gutterSize: "m",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      display: 'contents'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", {
    className: "eui-textTruncate"
  }, isUngrouped ? _constants.ungrouped : instanceId !== null && instanceId !== void 0 ? instanceId : '--', "\xA0", isUngrouped && /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observability.alert.grouping.ungrouped.info",
      defaultMessage: "There is no \"group by\" field selected in the rule definition."
    })
  }))))));
});
InstanceIdGroupContent.displayName = 'InstanceIdGroupContent';