"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInstallIntegrations = void 0;
var _react = require("react");
var _useTrackedPromise = require("@kbn/use-tracked-promise");
var _i18n = require("@kbn/i18n");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Errors
const UNAUTHORIZED_ERROR = _i18n.i18n.translate('xpack.observability_onboarding.installIntegration.error.unauthorized', {
  defaultMessage: 'Required kibana privilege {requiredKibanaPrivileges} is missing, please add the required privilege to the role of the authenticated user.',
  values: {
    requiredKibanaPrivileges: "['Fleet', 'Integrations']"
  }
});
const useInstallIntegrations = ({
  onIntegrationCreationSuccess,
  onIntegrationCreationFailure,
  packages = ['system']
}) => {
  const {
    services: {
      http
    }
  } = (0, _use_kibana.useKibana)();
  const [requestState, callPerformRequest] = (0, _useTrackedPromise.useTrackedPromise)({
    cancelPreviousOn: 'creation',
    createPromise: async () => {
      const options = {
        headers: {
          'Elastic-Api-Version': '2023-10-31'
        }
      };
      const integrations = [];
      for (const packageName of packages) {
        const {
          item: integration
        } = await http.get(`/api/fleet/epm/packages/${packageName}`, options);
        if (integration.status !== 'installed') {
          await http.post(`/api/fleet/epm/packages/${packageName}`, options);
        }
        integrations.push(integration);
      }
      return {
        versions: integrations.map(integration => integration.version)
      };
    },
    onResolve: ({
      versions
    }) => {
      onIntegrationCreationSuccess === null || onIntegrationCreationSuccess === void 0 ? void 0 : onIntegrationCreationSuccess({
        versions
      });
    },
    onReject: requestError => {
      var _requestError$body;
      if ((requestError === null || requestError === void 0 ? void 0 : (_requestError$body = requestError.body) === null || _requestError$body === void 0 ? void 0 : _requestError$body.statusCode) === 403) {
        onIntegrationCreationFailure({
          type: 'AuthorizationError',
          message: UNAUTHORIZED_ERROR
        });
      } else {
        var _requestError$body2;
        onIntegrationCreationFailure({
          type: 'UnknownError',
          message: requestError === null || requestError === void 0 ? void 0 : (_requestError$body2 = requestError.body) === null || _requestError$body2 === void 0 ? void 0 : _requestError$body2.message
        });
      }
    }
  }, [onIntegrationCreationSuccess, onIntegrationCreationFailure]);
  const performRequest = (0, _react.useCallback)(() => {
    callPerformRequest();
  }, [callPerformRequest]);
  return {
    performRequest,
    requestState
  };
};
exports.useInstallIntegrations = useInstallIntegrations;