"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WindowsInstallStep = WindowsInstallStep;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_STANDALONE_ELASTIC_AGENT_DOCS = 'https://www.elastic.co/guide/en/fleet/current/install-standalone-elastic-agent.html';
function WindowsInstallStep({
  docsLink = DEFAULT_STANDALONE_ELASTIC_AGENT_DOCS
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.observability_onboarding.windows.installStep.description', {
    defaultMessage: 'This onboarding is currently only available for Linux and MacOS systems. See our documentation for information on streaming log files to Elastic from a Windows system.'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconSide: "right",
    iconType: "popout",
    color: "primary",
    href: docsLink,
    target: "_blank",
    style: {
      width: 'fit-content'
    },
    "data-test-subj": "obltOnboardingInstallElasticAgentWindowsDocsLink"
  }, _i18n.i18n.translate('xpack.observability_onboarding.windows.installStep.link.label', {
    defaultMessage: 'Read docs'
  }))));
}