"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.constructLocatorPath = void 0;
var _common = require("@kbn/kibana-utils-plugin/common");
var _common2 = require("@kbn/logs-explorer-plugin/common");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _url_schema = require("../../url_schema");
var _deep_compact_object = require("../../utils/deep_compact_object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const constructLocatorPath = async params => {
  const {
    dataSourceSelection,
    locatorParams: {
      filterControls,
      filters,
      query,
      refreshInterval,
      timeRange,
      columns,
      origin,
      breakdownField
    },
    useHash
  } = params;
  const pageState = _url_schema.logsExplorerUrlSchemaV2.urlSchemaRT.encode((0, _deep_compact_object.deepCompactObject)({
    v: 2,
    dataSourceSelection,
    filters,
    query,
    refreshInterval,
    time: timeRange,
    breakdownField,
    columns: columns === null || columns === void 0 ? void 0 : columns.map(column => {
      return column.type === 'smart-field' ? _common2.SMART_FALLBACK_FIELDS[column.smartField] : column;
    }),
    controls: getControlsPageStateFromFilterControlsParams(filterControls !== null && filterControls !== void 0 ? filterControls : {})
  }));
  const path = (0, _common.setStateToKbnUrl)(_url_schema.OBSERVABILITY_LOGS_EXPLORER_URL_STATE_KEY, pageState, {
    useHash,
    storeInHashQuery: false
  }, '/');
  return {
    app: _deeplinksObservability.OBSERVABILITY_LOGS_EXPLORER_APP_ID,
    path,
    state: {
      ...(origin ? {
        origin
      } : {})
    }
  };
};
exports.constructLocatorPath = constructLocatorPath;
const getControlsPageStateFromFilterControlsParams = filterControls => ({
  ...(filterControls.namespace != null ? getFilterControlPageStateFromListFilterControlsParams(_common2.availableControlsPanels.NAMESPACE, filterControls.namespace) : {})
});
const getFilterControlPageStateFromListFilterControlsParams = (controlId, listFilterControl) => ({
  [controlId]: {
    mode: listFilterControl.mode,
    selection: {
      type: 'options',
      selectedOptions: listFilterControl.values
    }
  }
});