"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.conversationRoutes = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _types = require("../../../common/types");
var _create_observability_ai_assistant_server_route = require("../create_observability_ai_assistant_server_route");
var _runtime_types = require("../runtime_types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// backwards compatibility for messages with system role
const getConversationWithoutSystemMessages = conversation => {
  if (!conversation.systemMessage) {
    var _conversation$message, _conversation$message2, _conversation$message3;
    conversation.systemMessage = (_conversation$message = (_conversation$message2 = conversation.messages.find(message => message.message.role === 'system')) === null || _conversation$message2 === void 0 ? void 0 : (_conversation$message3 = _conversation$message2.message) === null || _conversation$message3 === void 0 ? void 0 : _conversation$message3.content) !== null && _conversation$message !== void 0 ? _conversation$message : '';
  }
  conversation.messages = conversation.messages.filter(message => message.message.role !== _types.MessageRole.System);
  return conversation;
};
const getConversationRoute = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'GET /internal/observability_ai_assistant/conversation/{conversationId}',
  params: t.type({
    path: t.type({
      conversationId: t.string
    })
  }),
  security: {
    authz: {
      requiredPrivileges: ['ai_assistant']
    }
  },
  handler: async resources => {
    const {
      service,
      request,
      params
    } = resources;
    const client = await service.getClient({
      request
    });
    const conversation = await client.get(params.path.conversationId);
    // conversation without system messages
    return getConversationWithoutSystemMessages(conversation);
  }
});
const findConversationsRoute = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'POST /internal/observability_ai_assistant/conversations',
  params: t.partial({
    body: t.partial({
      query: t.string
    })
  }),
  security: {
    authz: {
      requiredPrivileges: ['ai_assistant']
    }
  },
  handler: async resources => {
    var _params$body;
    const {
      service,
      request,
      params
    } = resources;
    const client = await service.getClient({
      request
    });
    const conversations = await client.find({
      query: params === null || params === void 0 ? void 0 : (_params$body = params.body) === null || _params$body === void 0 ? void 0 : _params$body.query
    });
    return {
      // conversations without system messages
      conversations: conversations.map(getConversationWithoutSystemMessages)
    };
  }
});
const createConversationRoute = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'POST /internal/observability_ai_assistant/conversation',
  params: t.type({
    body: t.type({
      conversation: _runtime_types.conversationCreateRt
    })
  }),
  security: {
    authz: {
      requiredPrivileges: ['ai_assistant']
    }
  },
  handler: async resources => {
    const {
      service,
      request,
      params
    } = resources;
    const client = await service.getClient({
      request
    });
    return client.create(params.body.conversation);
  }
});
const duplicateConversationRoute = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'POST /internal/observability_ai_assistant/conversation/{conversationId}/duplicate',
  params: t.type({
    path: t.type({
      conversationId: t.string
    })
  }),
  security: {
    authz: {
      requiredPrivileges: ['ai_assistant']
    }
  },
  handler: async resources => {
    const {
      service,
      request,
      params
    } = resources;
    const client = await service.getClient({
      request
    });
    return client.duplicateConversation(params.path.conversationId);
  }
});
const updateConversationRoute = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'PUT /internal/observability_ai_assistant/conversation/{conversationId}',
  params: t.type({
    path: t.type({
      conversationId: t.string
    }),
    body: t.type({
      conversation: _runtime_types.conversationUpdateRt
    })
  }),
  security: {
    authz: {
      requiredPrivileges: ['ai_assistant']
    }
  },
  handler: async resources => {
    const {
      service,
      request,
      params
    } = resources;
    const client = await service.getClient({
      request
    });
    return client.update(params.path.conversationId, params.body.conversation);
  }
});
const deleteConversationRoute = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'DELETE /internal/observability_ai_assistant/conversation/{conversationId}',
  params: t.type({
    path: t.type({
      conversationId: t.string
    })
  }),
  security: {
    authz: {
      requiredPrivileges: ['ai_assistant']
    }
  },
  handler: async resources => {
    const {
      service,
      request,
      params
    } = resources;
    const client = await service.getClient({
      request
    });
    return client.delete(params.path.conversationId);
  }
});
const patchConversationRoute = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'PATCH /internal/observability_ai_assistant/conversation/{conversationId}',
  params: t.type({
    path: t.type({
      conversationId: t.string
    }),
    body: t.partial({
      public: t.boolean,
      archived: t.boolean
    })
  }),
  security: {
    authz: {
      requiredPrivileges: ['ai_assistant']
    }
  },
  handler: async resources => {
    const {
      service,
      request,
      params
    } = resources;
    const client = await service.getClient({
      request
    });
    return client.updatePartial({
      conversationId: params.path.conversationId,
      updates: params.body
    });
  }
});
const conversationRoutes = exports.conversationRoutes = {
  ...getConversationRoute,
  ...findConversationsRoute,
  ...createConversationRoute,
  ...updateConversationRoute,
  ...deleteConversationRoute,
  ...duplicateConversationRoute,
  ...patchConversationRoute
};