"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Node = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _node_detail_status = require("../node_detail_status");
var _logs = require("../../logs");
var _chart = require("../../chart");
var _callout = require("../../../alerts/callout");
var _shard_allocation = require("../shard_allocation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Node = ({
  nodeSummary,
  metrics,
  logs,
  alerts,
  nodeId,
  clusterUuid,
  ...props
}) => {
  /*
  // This isn't doing anything due to a possible bug.  https://github.com/elastic/kibana/issues/106309
  if (alerts) {
    for (const alertTypeId of Object.keys(alerts)) {
      const alertInstance = alerts[alertTypeId];
      for (const { meta } of alertInstance.states) {
        const metricList = get(meta, 'metrics', []);
        for (const metric of metricList) {
          if (metrics[metric]) {
            metrics[metric].alerts = metrics[metric].alerts || {};
            metrics[metric].alerts[alertTypeId] = alertInstance;
          }
        }
      }
    }
  }
  */
  const metricsToShow = [metrics.node_jvm_mem, metrics.node_total_io, metrics.node_cpu_metric, metrics.node_load_average, metrics.node_latency, metrics.node_segment_count];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.elasticsearch.node.heading",
    defaultMessage: "Elasticsearch node"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_node_detail_status.NodeDetailStatus, {
    stats: nodeSummary,
    alerts: alerts
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_callout.AlertsCallout, {
    alerts: alerts
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    gutterSize: "s"
  }, metricsToShow.map((metric, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index
  }, /*#__PURE__*/_react.default.createElement(_chart.MonitoringTimeseriesContainer, (0, _extends2.default)({
    series: metric
  }, props)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_logs.Logs, {
    logs: logs,
    nodeId: nodeId,
    clusterUuid: clusterUuid
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_shard_allocation.ShardAllocation, props))));
};
exports.Node = Node;