"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnterpriseSearchPanel = EnterpriseSearchPanel;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _format_number = require("../../../lib/format_number");
var _helpers = require("./helpers");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _get_safe_for_external_link = require("../../../lib/get_safe_for_external_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EnterpriseSearchPanel(props) {
  const {
    setupMode
  } = props;
  const setupModeData = (0, _lodash.get)(setupMode.data, 'enterprise_search');
  const nodesCount = props.stats.totalInstances || 0;

  // Do not show if we are not in setup mode
  if (!nodesCount && !setupMode.enabled) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_helpers.ClusterItemContainer, (0, _extends2.default)({}, props, {
    url: "enterprise_search",
    title: _i18n.i18n.translate('xpack.monitoring.cluster.overview.entSearchPanel.entSearchTitle', {
      defaultMessage: 'Enterprise Search'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 4
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_helpers.DisabledIfNoDataAndInSetupModeLink, {
    setupModeEnabled: setupMode.enabled,
    setupModeData: setupModeData,
    href: (0, _get_safe_for_external_link.getSafeForExternalLink)('#/enterprise_search'),
    "aria-label": _i18n.i18n.translate('xpack.monitoring.cluster.overview.entSearchPanel.overviewLinkAriaLabel', {
      defaultMessage: 'Enterprise Search Overview'
    }),
    "data-test-subj": "entSearchOverview"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.entSearchPanel.overviewLinkLabel",
    defaultMessage: "Overview"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    className: "eui-textBreakWord"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.entSearchPanel.versionLabel",
    defaultMessage: "Version"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "entSearchVersion"
  }, props.stats.versions[0] || _i18n.i18n.translate('xpack.monitoring.cluster.overview.entSearchPanel.versionNotAvailableDescription', {
    defaultMessage: 'N/A'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    className: "eui-textBreakWord"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.entSearchPanel.appSearchEngines",
    defaultMessage: "Engines"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "appSearchEngines"
  }, props.stats.appSearchEngines), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    className: "eui-textBreakWord"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.entSearchPanel.workplaceSearchOrgSources",
    defaultMessage: "Org Sources"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "workplaceSearchOrgSources"
  }, props.stats.workplaceSearchOrgSources), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    className: "eui-textBreakWord"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.entSearchPanel.workplaceSearchPrivateSources",
    defaultMessage: "Private Sources"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "workplaceSearchPrivateSources"
  }, props.stats.workplaceSearchPrivateSources)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", {
    "data-test-subj": "entSearchTotalNodes"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.entSearchPanel.nodesTotalLinkLabel",
    defaultMessage: "Nodes: {nodesTotal}",
    values: {
      nodesTotal: (0, _format_number.formatNumber)(nodesCount, 'int_commas')
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    className: "eui-textBreakWord"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.entSearchPanel.memoryUsageLabel",
    defaultMessage: "Memory Usage"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "entSearchMemoryUsage"
  }, /*#__PURE__*/_react.default.createElement(_helpers.BytesPercentageUsage, {
    usedBytes: props.stats.memUsed,
    maxBytes: props.stats.memTotal
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    className: "eui-textBreakWord"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.entSearchPanel.uptimeLabel",
    defaultMessage: "Uptime"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "entSearchUptime"
  }, (0, _format_number.formatNumber)(props.stats.uptime, 'time_since')))))));
}