"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MemoryUsagePage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _mlDatePicker = require("@kbn/ml-date-picker");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _nodes_overview = require("./nodes_overview");
var _page_header = require("../components/page_header");
var _memory_tree_map = require("./memory_tree_map");
var _saved_objects_warning = require("../components/saved_objects_warning");
var _ml = require("../contexts/ml");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var TAB = /*#__PURE__*/function (TAB) {
  TAB[TAB["NODES"] = 0] = "NODES";
  TAB[TAB["MEMORY_USAGE"] = 1] = "MEMORY_USAGE";
  return TAB;
}(TAB || {});
const MemoryUsagePage = () => {
  const [selectedTab, setSelectedTab] = (0, _react.useState)(TAB.NODES);
  (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: false,
    autoRefreshSelector: true
  });
  const {
    showNodeInfo
  } = (0, _ml.useEnabledFeatures)();
  const refresh = (0, _react.useCallback)(() => {
    _mlDatePicker.mlTimefilterRefresh$.next({
      lastRefresh: Date.now()
    });
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    wrap: false,
    alignItems: 'center',
    gutterSize: 'm'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.memoryUsage.memoryUsageHeader",
    defaultMessage: "Memory Usage"
  })))), /*#__PURE__*/_react.default.createElement(_saved_objects_warning.SavedObjectsWarning, {
    onCloseFlyout: refresh
  }), showNodeInfo ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    "data-test-subj": "mlMemoryUsageTabs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: selectedTab === TAB.NODES,
    onClick: () => setSelectedTab(TAB.NODES),
    "data-test-subj": "mlMemoryUsageTab-nodes"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.memoryUsage.nodesTab",
    defaultMessage: "Nodes"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: selectedTab === TAB.MEMORY_USAGE,
    onClick: () => setSelectedTab(TAB.MEMORY_USAGE),
    "data-test-subj": "mlMemoryUsageTab-memory-usage"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.memoryUsage.memoryTab",
    defaultMessage: "Memory usage"
  }))), selectedTab === TAB.NODES ? /*#__PURE__*/_react.default.createElement(_nodes_overview.NodesList, null) : /*#__PURE__*/_react.default.createElement(_memory_tree_map.MemoryPage, null)) : /*#__PURE__*/_react.default.createElement(_memory_tree_map.JobMemoryTreeMap, null));
};
exports.MemoryUsagePage = MemoryUsagePage;