"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SkipValidationButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _step_types = require("../step_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SkipValidationButton = ({
  nextActive,
  setCurrentStep
}) => nextActive ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  onClick: () => setCurrentStep(_step_types.WIZARD_STEPS.SUMMARY),
  iconType: "arrowRight",
  iconSide: "right",
  "data-test-subj": "mlJobWizardNavButtonPrevious"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.ml.newJob.wizard.shopValidationButton",
  defaultMessage: "Skip validation"
}));
exports.SkipValidationButton = SkipValidationButton;