"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LegendDetails = LegendDetails;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactHooks = require("@kbn/react-hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function LegendDetails({
  inspectorAdapters,
  layer
}) {
  const errorTextStyle = (0, _reactHooks.useErrorTextStyle)();
  const errors = layer.getErrors(inspectorAdapters);
  if (errors.length) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, errors.map(({
      title,
      body
    }, index) => /*#__PURE__*/_react.default.createElement("div", {
      key: index
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "danger",
      size: "s",
      title: title,
      css: errorTextStyle
    }, body), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }))));
  }
  const warnings = layer.getWarnings();
  return warnings.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, warnings.map(({
    title,
    body
  }, index) => /*#__PURE__*/_react.default.createElement("div", {
    key: index
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    size: "s",
    css: errorTextStyle
  }, body), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }))), layer.renderLegendDetails()) : layer.renderLegendDetails();
}