"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataViewsContext = exports.DataViewsProvider = void 0;
var _react = require("react");
var _constate = _interopRequireDefault(require("constate"));
var _react2 = require("@xstate/react");
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _data_views = require("../state_machines/data_views");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDataViews = ({
  core,
  dataViewsService,
  events
}) => {
  const dataViewsStateService = (0, _react2.useInterpret)(() => (0, _data_views.createDataViewsStateMachine)({
    dataViews: dataViewsService
  }));
  const dataViews = (0, _react2.useSelector)(dataViewsStateService, state => state.context.dataViews);
  const dataViewCount = (0, _react2.useSelector)(dataViewsStateService, state => {
    var _state$context$dataVi;
    return ((_state$context$dataVi = state.context.dataViewsSource) === null || _state$context$dataVi === void 0 ? void 0 : _state$context$dataVi.length) || 0;
  });
  const error = (0, _react2.useSelector)(dataViewsStateService, state => state.context.error);
  const isLoading = (0, _react2.useSelector)(dataViewsStateService, state => state.matches('loading'));

  // Test whether a data view can be explored in Logs Explorer based on the settings
  const isDataViewAllowed = (0, _react.useCallback)(dataView => dataView.testAgainstAllowedList(core.uiSettings.get(_managementSettingsIds.OBSERVABILITY_LOGS_EXPLORER_ALLOWED_DATA_VIEWS_ID)), [core.uiSettings]);

  // Test whether a data view can be explored in Logs Explorer based on the settings or has fallback handler
  const isDataViewAvailable = (0, _react.useCallback)(dataView => {
    const isAllowedDataView = isDataViewAllowed(dataView);
    return isAllowedDataView || !isAllowedDataView && Boolean(events === null || events === void 0 ? void 0 : events.onUknownDataViewSelection);
  }, [isDataViewAllowed, events === null || events === void 0 ? void 0 : events.onUknownDataViewSelection]);
  const loadDataViews = (0, _react.useCallback)(() => dataViewsStateService.send({
    type: 'LOAD_DATA_VIEWS'
  }), [dataViewsStateService]);
  const reloadDataViews = (0, _react.useCallback)(() => dataViewsStateService.send({
    type: 'RELOAD_DATA_VIEWS'
  }), [dataViewsStateService]);
  const searchDataViews = (0, _react.useCallback)(searchParams => dataViewsStateService.send({
    type: 'SEARCH_DATA_VIEWS',
    search: searchParams
  }), [dataViewsStateService]);
  const filterDataViews = (0, _react.useCallback)(filterParams => dataViewsStateService.send({
    type: 'FILTER_DATA_VIEWS',
    filter: filterParams
  }), [dataViewsStateService]);
  const sortDataViews = (0, _react.useCallback)(searchParams => dataViewsStateService.send({
    type: 'SORT_DATA_VIEWS',
    search: searchParams
  }), [dataViewsStateService]);
  return {
    // Underlying state machine
    dataViewsStateService,
    // Failure states
    error,
    // Loading states
    isLoading,
    // Data
    dataViews,
    dataViewCount,
    // Actions
    isDataViewAllowed,
    isDataViewAvailable,
    loadDataViews,
    reloadDataViews,
    searchDataViews,
    filterDataViews,
    sortDataViews
  };
};
const [DataViewsProvider, useDataViewsContext] = (0, _constate.default)(useDataViews);
exports.useDataViewsContext = useDataViewsContext;
exports.DataViewsProvider = DataViewsProvider;