"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformElasticToList = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _convert_date_number_to_string = require("./convert_date_number_to_string");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformElasticToList = ({
  response
}) => {
  // @ts-expect-error created_at is incompatible
  return response.hits.hits.map(hit => {
    var _hit$_source, _hit$_source$meta, _hit$_source2;
    return {
      _version: (0, _securitysolutionEsUtils.encodeHitVersion)(hit),
      id: hit._id,
      ...hit._source,
      '@timestamp': (0, _convert_date_number_to_string.convertDateNumberToString)((_hit$_source = hit._source) === null || _hit$_source === void 0 ? void 0 : _hit$_source['@timestamp']),
      // meta can be null if deleted (empty in PUT payload), since update_by_query set deleted values as null
      // return it as undefined to keep it consistent with payload
      meta: (_hit$_source$meta = (_hit$_source2 = hit._source) === null || _hit$_source2 === void 0 ? void 0 : _hit$_source2.meta) !== null && _hit$_source$meta !== void 0 ? _hit$_source$meta : undefined
    };
  });
};
exports.transformElasticToList = transformElasticToList;