"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLegendStats = exports.checkTableForContainsSmallValues = void 0;
var _charts = require("@elastic/charts");
var _partition_charts_meta = require("./partition_charts_meta");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLegendStats = (layer, shape) => {
  var _PartitionChartsMeta$;
  if ('defaultLegendStats' in ((_PartitionChartsMeta$ = _partition_charts_meta.PartitionChartsMeta[shape]) === null || _PartitionChartsMeta$ === void 0 ? void 0 : _PartitionChartsMeta$.legend)) {
    var _ref, _layer$legendStats;
    return (_ref = (_layer$legendStats = layer.legendStats) !== null && _layer$legendStats !== void 0 ? _layer$legendStats : _partition_charts_meta.PartitionChartsMeta[shape].legend.defaultLegendStats) !== null && _ref !== void 0 ? _ref : [_charts.LegendValue.Value];
  }
};
exports.getLegendStats = getLegendStats;
const checkTableForContainsSmallValues = (dataTable, columnId, minPercentage) => {
  const overallSum = dataTable.rows.reduce((partialSum, row) => Number(row[columnId]) + partialSum, 0);
  return dataTable.rows.some(row => row[columnId] / overallSum * 100 < minPercentage);
};
exports.checkTableForContainsSmallValues = checkTableForContainsSmallValues;