"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultVisualValuesForLayer = getDefaultVisualValuesForLayer;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function hasSingleLayer(state) {
  return 'layerId' in state;
}
function mergeValues(memo, values, i) {
  // first the first entry, overwrite
  if (i === 0) {
    return {
      ...memo,
      ...values
    };
  }
  // after the first give priority to existent value
  return {
    ...values,
    ...memo
  };
}
function getDefaultVisualValuesForLayer(state, datasourceLayers) {
  const defaultValues = {
    truncateText: true
  };
  if (!state) {
    return defaultValues;
  }
  if (hasSingleLayer(state)) {
    var _datasourceLayers$sta;
    return Object.values(((_datasourceLayers$sta = datasourceLayers[state.layerId]) === null || _datasourceLayers$sta === void 0 ? void 0 : _datasourceLayers$sta.getVisualDefaults()) || {}).reduce(mergeValues, defaultValues);
  }
  return state.layers.flatMap(({
    layerId
  }) => {
    var _datasourceLayers$lay;
    return Object.values(((_datasourceLayers$lay = datasourceLayers[layerId]) === null || _datasourceLayers$lay === void 0 ? void 0 : _datasourceLayers$lay.getVisualDefaults()) || {});
  }).reduce(mergeValues, defaultValues);
}