"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TREE_VIEW = exports.LOGICAL = exports.INFRASTRUCTURE = void 0;
var _helpers = require("../helpers");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOGICAL_TREE_VIEW = [{
  key: _helpers.KUBERNETES_COLLECTION_FIELDS.clusterId,
  iconProps: _helpers.KUBERNETES_COLLECTION_ICONS_PROPS.clusterId,
  type: 'clusterId',
  name: _translations.translations.cluster(),
  namePlural: _translations.translations.cluster(true)
}, {
  key: _helpers.KUBERNETES_COLLECTION_FIELDS.namespace,
  iconProps: _helpers.KUBERNETES_COLLECTION_ICONS_PROPS.namespace,
  type: 'namespace',
  name: _translations.translations.namespace(),
  namePlural: _translations.translations.namespace(true)
}, {
  key: _helpers.KUBERNETES_COLLECTION_FIELDS.pod,
  iconProps: _helpers.KUBERNETES_COLLECTION_ICONS_PROPS.pod,
  type: 'pod',
  name: _translations.translations.pod(),
  namePlural: _translations.translations.pod(true)
}, {
  key: _helpers.KUBERNETES_COLLECTION_FIELDS.containerImage,
  iconProps: _helpers.KUBERNETES_COLLECTION_ICONS_PROPS.containerImage,
  type: 'containerImage',
  name: _translations.translations.containerImage(),
  namePlural: _translations.translations.containerImage(true)
}];
const INFRASTRUCTURE_TREE_VIEW = LOGICAL_TREE_VIEW.map((tree, index) => {
  if (index === 1) {
    return {
      key: _helpers.KUBERNETES_COLLECTION_FIELDS.node,
      iconProps: _helpers.KUBERNETES_COLLECTION_ICONS_PROPS.node,
      type: 'node',
      name: _translations.translations.node(),
      namePlural: _translations.translations.node(true)
    };
  }
  return tree;
});
const TREE_VIEW = exports.TREE_VIEW = {
  logical: LOGICAL_TREE_VIEW,
  infrastructure: INFRASTRUCTURE_TREE_VIEW
};
const INFRASTRUCTURE = exports.INFRASTRUCTURE = 'infrastructure';
const LOGICAL = exports.LOGICAL = 'logical';