"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withAvailability = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Wraps a request handler with a check for whether the API route is available.
 * The `isAvailable` flag must be provided by the context and be consistent with the required
 * license (stateful) or product type (serverless).
 */
const withAvailability = handler => {
  return async (context, req, res) => {
    const {
      isAvailable
    } = await context.integrationAssistant;
    if (!isAvailable()) {
      return res.notFound({
        body: {
          message: 'This API route is not available using your current license/tier.'
        }
      });
    }
    return handler(context, req, res);
  };
};
exports.withAvailability = withAvailability;