"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tryResolveAlias = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Sometimes the LLM request documentation by wrongly naming the command.
 * This is mostly for the case for STATS.
 */
const aliases = {
  STATS: ['STATS_BY', 'BY', 'STATS...BY', 'STATS ... BY'],
  OPERATORS: ['LIKE', 'RLIKE', 'IN'],
  LOOKUP_JOIN: ['LOOKUPJOIN']
};
const getAliasMap = () => {
  return Object.entries(aliases).reduce((aliasMap, [command, commandAliases]) => {
    commandAliases.forEach(alias => {
      aliasMap[alias] = command;
    });
    return aliasMap;
  }, {});
};
const aliasMap = getAliasMap();
const tryResolveAlias = maybeAlias => {
  var _aliasMap$maybeAlias;
  return (_aliasMap$maybeAlias = aliasMap[maybeAlias]) !== null && _aliasMap$maybeAlias !== void 0 ? _aliasMap$maybeAlias : maybeAlias;
};
exports.tryResolveAlias = tryResolveAlias;