"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sortTable = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const unitMagnitude = {
  kb: 1,
  mb: 2,
  gb: 3,
  tb: 4,
  pb: 5
};
const numericSort = fieldName => item => Number(item[fieldName]);
const byteSort = fieldName => item => {
  const rawValue = String(item[fieldName]);
  // raw value can be missing if index is closed
  if (!rawValue) {
    return 0;
  }
  const matchResult = rawValue.match(/(.*)([kmgtp]b)/);
  if (!matchResult) {
    return 0;
  }
  const [, number, unit] = matchResult;
  return +number * Math.pow(1024, unitMagnitude[unit]);
};
const getSorters = extensionsService => {
  var _extensionsService$co;
  const sorters = {
    primary: numericSort('primary'),
    replica: numericSort('replica'),
    documents: numericSort('documents'),
    size: byteSort('size'),
    primary_size: byteSort('primary_size')
  };
  const columns = (_extensionsService$co = extensionsService === null || extensionsService === void 0 ? void 0 : extensionsService.columns) !== null && _extensionsService$co !== void 0 ? _extensionsService$co : [];
  for (const column of columns) {
    if (column.sort) {
      sorters[column.fieldName] = column.sort;
    }
  }
  return sorters;
};
const sortTable = (array = [], sortField, isSortAscending, extensionsService) => {
  const sorters = getSorters(extensionsService);
  let sorter = sorters[sortField];
  if (!sorter) {
    sorter = index => (0, _lodash.get)(index, sortField);
  }
  const sorted = (0, _lodash.sortBy)(array, sorter);
  return isSortAscending ? sorted : sorted.reverse();
};
exports.sortTable = sortTable;