"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PutOutputRequestSchema = exports.PostOutputRequestSchema = exports.GetOutputsRequestSchema = exports.GetOneOutputRequestSchema = exports.GetLatestOutputHealthRequestSchema = exports.DeleteOutputRequestSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _models = require("../models");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GetOneOutputRequestSchema = exports.GetOneOutputRequestSchema = {
  params: _configSchema.schema.object({
    outputId: _configSchema.schema.string()
  })
};
const DeleteOutputRequestSchema = exports.DeleteOutputRequestSchema = {
  params: _configSchema.schema.object({
    outputId: _configSchema.schema.string()
  })
};
const GetOutputsRequestSchema = exports.GetOutputsRequestSchema = {};
const PostOutputRequestSchema = exports.PostOutputRequestSchema = {
  body: _models.OutputSchema
};
const PutOutputRequestSchema = exports.PutOutputRequestSchema = {
  params: _configSchema.schema.object({
    outputId: _configSchema.schema.string()
  }),
  body: _models.UpdateOutputSchema
};
const GetLatestOutputHealthRequestSchema = exports.GetLatestOutputHealthRequestSchema = {
  params: _configSchema.schema.object({
    outputId: _configSchema.schema.string()
  })
};