"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LicenseModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LicenseModal = ({
  licenseName = 'LICENSE.txt',
  licensePath,
  onClose
}) => {
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const {
    data: licenseResponse,
    error: licenseError,
    isLoading
  } = (0, _hooks.useGetFileByPathQuery)(licensePath);
  const licenseText = licenseResponse === null || licenseResponse === void 0 ? void 0 : licenseResponse.data;
  if (licenseError) {
    notifications.toasts.addError(licenseError, {
      title: _i18n.i18n.translate('xpack.fleet.epm.errorLoadingLicense', {
        defaultMessage: 'Error loading license information'
      })
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    maxWidth: true,
    onClose: onClose
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, licenseName)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 10,
    size: "s",
    isLoading: isLoading,
    contentAriaLabel: "License text"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    overflowHeight: 360
  }, licenseText))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    fill: true,
    onClick: onClose
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.licenseModalCloseBtn",
    defaultMessage: "Close"
  }))));
};
exports.LicenseModal = LicenseModal;