"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFormattedRange = exports.ViewLogsButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/logs-shared-plugin/common");
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../../hooks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFormattedRange = date => new Date(date).getTime();

/*
  Button that takes to the Logs view UI or the Discover logs, depending on what's available
  If none is available, don't display the button at all
*/
exports.getFormattedRange = getFormattedRange;
const ViewLogsButton = ({
  logStreamQuery,
  startTime,
  endTime
}) => {
  const {
    share
  } = (0, _hooks.useStartServices)();
  const {
    discoverLogsLocator
  } = (0, _common.getLogsLocatorsFromUrlService)(share.url);
  const authz = (0, _hooks.useAuthz)();
  const logsUrl = (0, _react.useMemo)(() => {
    const now = (0, _moment.default)().toISOString();
    const oneDayAgo = (0, _moment.default)().subtract(1, 'day').toISOString();
    const defaultStartTime = getFormattedRange(oneDayAgo);
    const defaultEndTime = getFormattedRange(now);
    return discoverLogsLocator === null || discoverLogsLocator === void 0 ? void 0 : discoverLogsLocator.getRedirectUrl({
      time: endTime ? endTime : defaultEndTime,
      timeRange: {
        from: (0, _common.getTimeRangeStartFromTime)(startTime ? startTime : defaultStartTime),
        to: (0, _common.getTimeRangeEndFromTime)(endTime ? endTime : defaultEndTime)
      },
      query: {
        language: 'kuery',
        query: logStreamQuery
      }
    });
  }, [endTime, logStreamQuery, discoverLogsLocator, startTime]);
  return authz.fleet.readAgents && logsUrl ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    href: logsUrl,
    iconType: "discoverApp",
    "data-test-subj": "viewInLogsBtn"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentLogs.openInDiscoverUiLinkText",
    defaultMessage: "Open in Discover"
  })) : null;
};
exports.ViewLogsButton = ViewLogsButton;