"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFileMetadataIndexName = exports.getFileDataIndexName = void 0;
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns the index name for File Metadata storage for a given integration
 * @param integrationName
 * @param forHostDelivery
 */
const getFileMetadataIndexName = (integrationName, /** if set to true, then the index returned will be for files that are being sent to the host */
forHostDelivery = false) => {
  const metaIndex = forHostDelivery ? _constants.FILE_STORAGE_TO_HOST_METADATA_INDEX_PATTERN : _constants.FILE_STORAGE_METADATA_INDEX_PATTERN;
  if (metaIndex.indexOf('*') !== -1) {
    return metaIndex.replace('*', integrationName);
  }
  throw new Error(`Unable to define integration file data index. No '*' in index pattern: ${metaIndex}`);
};
/**
 * Returns the index name for File data (chunks) storage for a given integration
 * @param integrationName
 */
exports.getFileMetadataIndexName = getFileMetadataIndexName;
const getFileDataIndexName = (integrationName, /** if set to true, then the index returned will be for files that are being sent to the host */
forHostDelivery = false) => {
  const dataIndex = forHostDelivery ? _constants.FILE_STORAGE_TO_HOST_DATA_INDEX_PATTERN : _constants.FILE_STORAGE_DATA_INDEX_PATTERN;
  if (dataIndex.indexOf('*') !== -1) {
    return dataIndex.replace('*', integrationName);
  }
  throw new Error(`Unable to define integration file data index. No '*' in index pattern: ${dataIndex}`);
};
exports.getFileDataIndexName = getFileDataIndexName;