"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFromCommand = void 0;
var _esql_parser = require("../../antlr/esql_parser");
var _factories = require("../factories");
var _walkers = require("../walkers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createFromCommand = ctx => {
  const command = (0, _factories.createCommand)('from', ctx);
  const indexPatternCtx = ctx.indexPatternAndMetadataFields();
  const metadataCtx = indexPatternCtx.metadata();
  const sources = indexPatternCtx.getTypedRuleContexts(_esql_parser.IndexPatternContext).map(sourceCtx => (0, _factories.visitSource)(sourceCtx));
  command.args.push(...sources);
  if (metadataCtx && metadataCtx.METADATA()) {
    const name = metadataCtx.METADATA().getText().toLowerCase();
    const option = (0, _factories.createOption)(name, metadataCtx);
    const optionArgs = (0, _walkers.collectAllColumnIdentifiers)(metadataCtx);
    option.args.push(...optionArgs);
    command.args.push(option);
  }
  return command;
};
exports.createFromCommand = createFromCommand;