"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupManagerModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react_router_helpers = require("../../../../shared/react_router_helpers");
var _share_circle = _interopRequireDefault(require("../../../assets/share_circle.svg"));
var _constants = require("../../../constants");
var _routes = require("../../../routes");
var _group_logic = require("../group_logic");
var _groups_logic = require("../groups_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ADD_SOURCE_BUTTON_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.groupManagerUpdateAddSourceButton', {
  defaultMessage: 'Add an organizational source'
});
const EMPTY_STATE_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.groupManagerSourceEmpty.title', {
  defaultMessage: 'Whoops!'
});
const EMPTY_STATE_BODY = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.groupManagerSourceEmpty.body', {
  defaultMessage: 'Looks like you have not added any organizational content sources yet.'
});
const ADD_SOURCE_MODAL_SELECT_BUTTON = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.groupManagerSourceModal.selectButton.text', {
  defaultMessage: 'Select all'
});
const ADD_SOURCE_MODAL_DESELECT_BUTTON = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.groupManagerSourceModal.deselectButton.text', {
  defaultMessage: 'Deselect all'
});
const GroupManagerModal = ({
  children,
  label,
  allItems,
  numSelected,
  hideModal,
  selectAll,
  saveItems
}) => {
  const {
    group,
    managerModalFormErrors
  } = (0, _kea.useValues)(_group_logic.GroupLogic);
  const {
    contentSources
  } = (0, _kea.useValues)(_groups_logic.GroupsLogic);
  const allSelected = numSelected === allItems.length;
  const showEmptyState = contentSources.length < 1;
  const handleClose = () => hideModal(group);
  const handleSelectAll = () => selectAll(allSelected ? [] : allItems);
  const sourcesButton = /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
    to: _routes.SOURCES_PATH,
    fill: true,
    color: "primary"
  }, ADD_SOURCE_BUTTON_TEXT);
  const emptyState = /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: _share_circle.default,
    title: /*#__PURE__*/_react.default.createElement("h3", null, EMPTY_STATE_TITLE),
    body: EMPTY_STATE_BODY,
    actions: sourcesButton
  }));
  const modalContent = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.groupManagerHeaderTitle', {
    defaultMessage: 'Manage {label}',
    values: {
      label
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    error: managerModalFormErrors,
    isInvalid: managerModalFormErrors.length > 0,
    fullWidth: true
  }, children)))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "SelectAllGroups",
    onClick: handleSelectAll
  }, allSelected ? ADD_SOURCE_MODAL_DESELECT_BUTTON : ADD_SOURCE_MODAL_SELECT_BUTTON)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "CloseGroupsModal",
    onClick: handleClose
  }, _constants.CANCEL_BUTTON)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isDisabled: false,
    onClick: saveItems,
    fill: true
  }, _constants.UPDATE_BUTTON)))))));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: handleClose,
    initialFocus: ".euiFieldSearch",
    "data-test-subj": "GroupManagerModal"
  }, showEmptyState ? emptyState : modalContent);
};
exports.GroupManagerModal = GroupManagerModal;