"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClearFiltersLink = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _groups_logic = require("../groups_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CLEAR_FILTERS = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.clearFilters.action', {
  defaultMessage: 'Clear Filters'
});
const ClearFiltersLink = () => {
  const {
    resetGroupsFilters
  } = (0, _kea.useActions)(_groups_logic.GroupsLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: resetGroupsFilters
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexStart",
    gutterSize: "xs",
    component: "span"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement("small", null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "cross"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement("small", null, CLEAR_FILTERS))));
};
exports.ClearFiltersLink = ClearFiltersLink;