"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.readUploadedFileAsText = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const readUploadedFileAsText = fileInput => {
  const reader = new FileReader();
  return new Promise((resolve, reject) => {
    reader.onload = () => {
      resolve(reader.result);
    };
    try {
      reader.readAsText(fileInput);
    } catch {
      reader.abort();
      reject(new Error());
    }
  });
};
exports.readUploadedFileAsText = readUploadedFileAsText;