"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrawlerStatusIndicator = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _types = require("../../../api/crawler/types");
var _crawler_logic = require("../../search_index/crawler/crawler_logic");
var _start_crawl_context_menu = require("./start_crawl_context_menu");
var _stop_crawl_popover_context_menu = require("./stop_crawl_popover_context_menu");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CrawlerStatusIndicator = () => {
  const {
    dataLoading,
    domains,
    mostRecentCrawlRequestStatus
  } = (0, _kea.useValues)(_crawler_logic.CrawlerLogic);
  if (dataLoading || domains.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      disabled: true,
      iconType: "arrowDown",
      iconSide: "right"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlerStatusIndicator.startACrawlButtonLabel', {
      defaultMessage: 'Crawl'
    }));
  }
  switch (mostRecentCrawlRequestStatus) {
    case _types.CrawlerStatus.Pending:
    case _types.CrawlerStatus.Suspended:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        isLoading: true
      }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlerStatusIndicator.pendingButtonLabel', {
        defaultMessage: 'Pending...'
      }));
    case _types.CrawlerStatus.Starting:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        isLoading: true
      }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlerStatusIndicator.startingButtonLabel', {
        defaultMessage: 'Starting...'
      }));
    case _types.CrawlerStatus.Running:
      return /*#__PURE__*/_react.default.createElement(_stop_crawl_popover_context_menu.StopCrawlPopoverContextMenu, null);
    case _types.CrawlerStatus.Canceling:
    case _types.CrawlerStatus.Suspending:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        isLoading: true
      }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlerStatusIndicator.stoppingButtonLabel', {
        defaultMessage: 'Stopping...'
      }));
    case _types.CrawlerStatus.Success:
    case _types.CrawlerStatus.Failed:
    case _types.CrawlerStatus.Canceled:
    default:
      return /*#__PURE__*/_react.default.createElement(_start_crawl_context_menu.StartCrawlContextMenu, null);
  }
};
exports.CrawlerStatusIndicator = CrawlerStatusIndicator;