"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Synonyms = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _engine = require("../engine");
var _layout = require("../layout");
var _components = require("./components");
var _constants = require("./constants");
var _ = require(".");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Synonyms = () => {
  const {
    loadSynonyms,
    onPaginate,
    openModal
  } = (0, _kea.useActions)(_.SynonymsLogic);
  const {
    synonymSets,
    meta,
    dataLoading
  } = (0, _kea.useValues)(_.SynonymsLogic);
  const hasSynonyms = synonymSets.length > 0;
  (0, _react.useEffect)(() => {
    loadSynonyms();
  }, [meta.page.current]);
  (0, _react.useEffect)(() => {
    // If users delete the only synonym set on the page, send them back to the previous page
    if (!hasSynonyms && meta.page.current !== 1) {
      onPaginate(meta.page.current - 1);
    }
  }, [synonymSets]);
  return /*#__PURE__*/_react.default.createElement(_layout.AppSearchPageTemplate, {
    pageChrome: (0, _engine.getEngineBreadcrumbs)([_constants.SYNONYMS_TITLE]),
    pageHeader: {
      pageTitle: _constants.SYNONYMS_TITLE,
      description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.synonyms.description', {
        defaultMessage: 'Use synonyms to relate queries together that contextually have the same meaning in your dataset.'
      }),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        fill: true,
        iconType: "plusInCircle",
        onClick: () => openModal(null)
      }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.synonyms.createSynonymSetButtonLabel', {
        defaultMessage: 'Create a synonym set'
      }))]
    },
    isLoading: dataLoading && !hasSynonyms,
    isEmptyState: !hasSynonyms,
    emptyState: /*#__PURE__*/_react.default.createElement(_components.EmptyState, null)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 3
  }, synonymSets.map(({
    id,
    synonyms
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: id
  }, /*#__PURE__*/_react.default.createElement(_components.SynonymCard, {
    id: id,
    synonyms: synonyms
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
    pageCount: meta.page.total_pages,
    activePage: meta.page.current - 1,
    onPageClick: pageIndex => onPaginate(pageIndex + 1)
  }), /*#__PURE__*/_react.default.createElement(_components.SynonymModal, null));
};
exports.Synonyms = Synonyms;