"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.internalStateSlice = exports.createInternalStateStore = void 0;
var _uuid = require("uuid");
var _toolkit = require("@reduxjs/toolkit");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const initialState = {
  dataViewId: undefined,
  isDataViewLoading: false,
  defaultProfileAdHocDataViewIds: [],
  savedDataViews: [],
  expandedDoc: undefined,
  customFilters: [],
  dataRequestParams: {},
  overriddenVisContextAfterInvalidation: undefined,
  isESQLToDataViewTransitionModalVisible: false,
  resetDefaultProfileState: {
    resetId: '',
    columns: false,
    rowHeight: false,
    breakdownField: false,
    hideChart: false
  }
};
const internalStateSlice = exports.internalStateSlice = (0, _toolkit.createSlice)({
  name: 'internalState',
  initialState,
  reducers: {
    setDataViewId: (state, action) => {
      if (action.payload !== state.dataViewId) {
        state.expandedDoc = undefined;
      }
      state.dataViewId = action.payload;
    },
    setIsDataViewLoading: (state, action) => {
      state.isDataViewLoading = action.payload;
    },
    setDefaultProfileAdHocDataViewIds: (state, action) => {
      state.defaultProfileAdHocDataViewIds = action.payload;
    },
    setSavedDataViews: (state, action) => {
      state.savedDataViews = action.payload;
    },
    setExpandedDoc: (state, action) => {
      state.expandedDoc = action.payload.expandedDoc;
      state.initialDocViewerTabId = action.payload.initialDocViewerTabId;
    },
    setCustomFilters: (state, action) => {
      state.customFilters = action.payload;
    },
    setDataRequestParams: (state, action) => {
      state.dataRequestParams = action.payload;
    },
    setOverriddenVisContextAfterInvalidation: (state, action) => {
      state.overriddenVisContextAfterInvalidation = action.payload;
    },
    setIsESQLToDataViewTransitionModalVisible: (state, action) => {
      state.isESQLToDataViewTransitionModalVisible = action.payload;
    },
    setResetDefaultProfileState: {
      prepare: resetDefaultProfileState => ({
        payload: {
          ...resetDefaultProfileState,
          resetId: (0, _uuid.v4)()
        }
      }),
      reducer: (state, action) => {
        state.resetDefaultProfileState = action.payload;
      }
    },
    resetOnSavedSearchChange: state => {
      state.overriddenVisContextAfterInvalidation = undefined;
      state.expandedDoc = undefined;
    }
  }
});
const createInternalStateStore = options => (0, _toolkit.configureStore)({
  reducer: internalStateSlice.reducer,
  middleware: getDefaultMiddleware => getDefaultMiddleware({
    thunk: {
      extraArgument: options
    }
  })
});
exports.createInternalStateStore = createInternalStateStore;