"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SolutionsViewBadge = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _use_discover_services = require("../../../../hooks/use_discover_services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const SolutionsViewBadge = ({
  badgeText
}) => {
  var _services$capabilitie, _services$spaces2;
  const services = (0, _use_discover_services.useDiscoverServices)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const activeSpace$ = (0, _react.useMemo)(() => {
    var _services$spaces$getA, _services$spaces;
    return (_services$spaces$getA = (_services$spaces = services.spaces) === null || _services$spaces === void 0 ? void 0 : _services$spaces.getActiveSpace$()) !== null && _services$spaces$getA !== void 0 ? _services$spaces$getA : (0, _rxjs.of)(undefined);
  }, [services.spaces]);
  const activeSpace = (0, _useObservable.default)(activeSpace$);
  const canManageSpaces = ((_services$capabilitie = services.capabilities.spaces) === null || _services$capabilitie === void 0 ? void 0 : _services$capabilitie.manage) === true;

  // Do not render this component if one of the following conditions is met:
  // 1. Solution visibility feature is disabled
  // 2. Spaces is disabled (No active space available)
  // 3. Active space is already configured to use a solution view other than "classic".
  if (!((_services$spaces2 = services.spaces) !== null && _services$spaces2 !== void 0 && _services$spaces2.isSolutionViewEnabled) || !activeSpace || activeSpace.solution && activeSpace.solution !== 'classic') {
    return null;
  }
  const onClickAriaLabel = _i18n.i18n.translate('discover.topNav.solutionsViewBadge.clickToLearnMoreAriaLabel', {
    defaultMessage: 'Click to learn more about the “solution view”'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      iconType: "question",
      iconSide: "right",
      onClick: () => setIsPopoverOpen(value => !value),
      onClickAriaLabel: onClickAriaLabel
    }, badgeText),
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    panelStyle: {
      maxWidth: 300
    }
  }, canManageSpaces ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.topNav.solutionsViewBadge.canManageSpacesDescription",
    defaultMessage: "We improved Discover so your view adapts to what you're exploring. Choose Observability or Security as your \u201Csolution view\u201D in your space settings."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: services.addBasePath(`/app/management/kibana/spaces/edit/${activeSpace.id}`),
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.topNav.solutionsViewBadge.spaceSettingsLink",
    defaultMessage: "Space settings"
  })))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.topNav.solutionsViewBadge.cannotManageSpacesDescription",
    defaultMessage: "We enhanced Discover to adapt seamlessly to what you're exploring. Select Observability or Security as the \u201Csolution view\u201D \u2014 ask your admin to set it in the space settings."
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: `${services.docLinks.ELASTIC_WEBSITE_URL}guide/en/kibana/8.16/whats-new.html#_contextual_data_presentation` // Hardcoded to 8.16 since release notes for other versions will not include the linked feature
    ,
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.topNav.solutionsViewBadge.releaseNotesLink",
    defaultMessage: "Check out the release notes"
  })))));
};
exports.SolutionsViewBadge = SolutionsViewBadge;