"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataViewEditor = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _data_view_editor_lazy = require("./data_view_editor_lazy");
var _shared_imports = require("../shared_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DataViewEditor = ({
  onSave,
  onCancel = () => {},
  services,
  defaultTypeIsRollup = false,
  requireTimestampField = false,
  editData,
  allowAdHocDataView
}) => {
  const {
    Provider: KibanaReactContextProvider
  } = (0, _shared_imports.createKibanaReactContext)(services);
  return /*#__PURE__*/_react.default.createElement(KibanaReactContextProvider, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: () => {},
    hideCloseButton: true,
    size: "l"
  }, /*#__PURE__*/_react.default.createElement(_data_view_editor_lazy.DataViewEditorLazy, {
    onSave: onSave,
    onCancel: onCancel,
    defaultTypeIsRollup: defaultTypeIsRollup,
    requireTimestampField: requireTimestampField,
    editData: editData,
    allowAdHocDataView: allowAdHocDataView
  })));
};
exports.DataViewEditor = DataViewEditor;