"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.relativeToAbsolute = relativeToAbsolute;
exports.toNavLink = toNavLink;
var _coreApplicationBrowser = require("@kbn/core-application-browser");
var _coreApplicationBrowserInternal = require("@kbn/core-application-browser-internal");
var _nav_link = require("./nav_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function toNavLink(app, basePath, deepLink) {
  const relativeBaseUrl = basePath.prepend(app.appRoute);
  const url = (0, _coreApplicationBrowserInternal.appendAppPath)(relativeBaseUrl, (deepLink === null || deepLink === void 0 ? void 0 : deepLink.path) || app.defaultPath);
  const href = relativeToAbsolute(url);
  const baseUrl = relativeToAbsolute(relativeBaseUrl);
  if (app.status === _coreApplicationBrowser.AppStatus.inaccessible) return null;
  return new _nav_link.NavLinkWrapper({
    ...(deepLink || app),
    ...(app.category ? {
      category: app.category
    } : {}),
    // deepLinks use the main app category
    baseUrl,
    href,
    url
  });
}

/**
 * @param {string} url - a relative or root relative url.  If a relative path is given then the
 * absolute url returned will depend on the current page where this function is called from. For example
 * if you are on page "http://www.mysite.com/shopping/kids" and you pass this function "adults", you would get
 * back "http://www.mysite.com/shopping/adults".  If you passed this function a root relative path, or one that
 * starts with a "/", for example "/account/cart", you would get back "http://www.mysite.com/account/cart".
 * @return {string} the relative url transformed into an absolute url
 */
function relativeToAbsolute(url) {
  const a = document.createElement('a');
  a.setAttribute('href', url);
  return a.href;
}