"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCloudDefendSetupStatusApi = void 0;
var _reactQuery = require("@kbn/react-query");
var _use_kibana = require("../hooks/use_kibana");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCloudDefendSetupStatusQueryKey = 'cloud_defend_status_key';
const useCloudDefendSetupStatusApi = () => {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  return (0, _reactQuery.useQuery)([getCloudDefendSetupStatusQueryKey], () => http.get(_constants.STATUS_ROUTE_PATH, {
    version: _constants.CURRENT_API_VERSION
  }));
};
exports.useCloudDefendSetupStatusApi = useCloudDefendSetupStatusApi;