"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimeRange = useTimeRange;
var _react = require("react");
var _use_time_range_id = require("../context/time_range_id/use_time_range_id");
var _helpers = require("../context/url_params_context/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useTimeRange({
  rangeFrom,
  rangeTo,
  optional
}) {
  const {
    incrementTimeRangeId,
    timeRangeId
  } = (0, _use_time_range_id.useTimeRangeId)();
  const {
    start,
    end
  } = (0, _react.useMemo)(() => {
    return (0, _helpers.getDateRange)({
      state: {},
      rangeFrom,
      rangeTo
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [rangeFrom, rangeTo, timeRangeId]);
  if ((!start || !end) && !optional) {
    throw new Error('start and/or end were unexpectedly not set');
  }
  return {
    start,
    end,
    refreshTimeRange: incrementTimeRangeId,
    timeRangeId
  };
}