"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentKeysTable = AgentKeysTable;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _timestamp_tooltip = require("../../../shared/timestamp_tooltip");
var _confirm_delete_modal = require("./confirm_delete_modal");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AgentKeysTable({
  agentKeys,
  onKeyDelete,
  canManage
}) {
  const [agentKeyToBeDeleted, setAgentKeyToBeDeleted] = (0, _react.useState)();
  const columns = [{
    field: 'name',
    name: _i18n.i18n.translate('xpack.apm.settings.agentKeys.table.nameColumnName', {
      defaultMessage: 'Name'
    }),
    sortable: true
  }, {
    field: 'username',
    name: _i18n.i18n.translate('xpack.apm.settings.agentKeys.table.userNameColumnName', {
      defaultMessage: 'User'
    }),
    sortable: true
  }, {
    field: 'realm',
    name: _i18n.i18n.translate('xpack.apm.settings.agentKeys.table.realmColumnName', {
      defaultMessage: 'Realm'
    }),
    sortable: true
  }, {
    field: 'creation',
    name: _i18n.i18n.translate('xpack.apm.settings.agentKeys.table.creationColumnName', {
      defaultMessage: 'Created'
    }),
    dataType: 'date',
    sortable: true,
    mobileOptions: {
      show: false
    },
    render: date => /*#__PURE__*/_react.default.createElement(_timestamp_tooltip.TimestampTooltip, {
      time: date
    })
  }];
  if (canManage) {
    columns.push({
      actions: [{
        name: _i18n.i18n.translate('xpack.apm.settings.agentKeys.table.deleteActionTitle', {
          defaultMessage: 'Delete'
        }),
        description: _i18n.i18n.translate('xpack.apm.settings.agentKeys.table.deleteActionDescription', {
          defaultMessage: 'Delete this APM agent key'
        }),
        icon: 'trash',
        color: 'danger',
        type: 'icon',
        onClick: agentKey => setAgentKeyToBeDeleted(agentKey)
      }]
    });
  }
  const search = {
    box: {
      incremental: true
    },
    filters: [{
      type: 'field_value_selection',
      field: 'username',
      name: _i18n.i18n.translate('xpack.apm.settings.agentKeys.table.userFilterLabel', {
        defaultMessage: 'User'
      }),
      multiSelect: 'or',
      operator: 'exact',
      options: Object.keys(agentKeys.reduce((acc, {
        username
      }) => {
        acc[username] = true;
        return acc;
      }, {})).map(value => ({
        value
      }))
    }, {
      type: 'field_value_selection',
      field: 'realm',
      name: _i18n.i18n.translate('xpack.apm.settings.agentKeys.table.realmFilterLabel', {
        defaultMessage: 'Realm'
      }),
      multiSelect: 'or',
      operator: 'exact',
      options: Object.keys(agentKeys.reduce((acc, {
        realm
      }) => {
        acc[realm] = true;
        return acc;
      }, {})).map(value => ({
        value
      }))
    }]
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    tableCaption: _i18n.i18n.translate('xpack.apm.settings.agentKeys.tableCaption', {
      defaultMessage: 'APM agent keys'
    }),
    items: agentKeys !== null && agentKeys !== void 0 ? agentKeys : [],
    columns: columns,
    pagination: true,
    search: search,
    sorting: true
  }), agentKeyToBeDeleted && /*#__PURE__*/_react.default.createElement(_confirm_delete_modal.ConfirmDeleteModal, {
    onCancel: () => setAgentKeyToBeDeleted(undefined),
    agentKey: agentKeyToBeDeleted,
    onConfirm: () => {
      setAgentKeyToBeDeleted(undefined);
      onKeyDelete();
    }
  }));
}